<?php

namespace App\Models\Complexe;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Complexe extends Model 
{

    protected $table = 'complexes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('App\Models\User\User');
    }

    public function package()
    {
        return $this->belongsTo('App\Models\Package');
    }

}